<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Routing\Redirector;

class AdminController extends Controller
{

    public function __construct(Request $request, Redirector $redirect)
    {
        $segment = $request->segment(1);
        if($request->segment(2) != '')
            $segment = $segment .'/'. $request->segment(2);

        if($segment != "admin/login"){
            if(!$this->isALogin()  ){
                if($request->isMethod('post'))
                {
                    die();
                }
            }
        }
    }

    public function login(){

        if(!$this->isALogin()){
            $data["msg"]    = "";
            $data["login"] = false;
            return view('admin/login',$data);
        }else{
            return redirect('/admin');
        }
    }
    public function loginProcess(Request $request)
    {
        $data["msg"]    = "";
        $data["login"] = false;
        $name           = $request->input("uname");
        $pass           = $request->input("pass");
        $user           = DB::select(" SELECT  * FROM tbl_user WHERE role='admin' AND `name` = ? ;",[$name]);
        if($user != null){
            if($user[0]->is_active == 1 and $user[0]->is_banned == 0){
                if($user[0]->pass == $pass){
                    $ldate = date('Y-m-d H:i:s');
                    $s_user['name']         = $name;
                    $s_user['pass']         =  Crypt::encryptString($pass);   // Crypt::decryptString($encryptedValue);
                    $s_user['is_login']     = true;
                    $s_user['login_time']   = $ldate;
                    $info['url']            = "/admin";
                    // $_SESSION['user']       = $s_user;
                    session(['auser' => $s_user]);
                    session(['info' => $info]);
                    return redirect('/admin/login');
                }else{
                    $data["msg"]    = "Check your username and password.";
                }
            }else{
                $data["msg"]    = "Contact to admin,your account need to fix";
            }
        }else{
            $data["msg"]    = "Wrong Information";
        }
        return view('admin/login',$data);
    }

    public function admin(){

        if($this->isALogin()){

            $data['bread_crumb']= "Home";
            $userid = 2;

            $bet_data   = DB::select("SELECT MIN(digit) AS digit, SUM(amt) t_amt FROM tbl_bet WHERE userid=? AND time_ =2 AND date_ = CURRENT_DATE GROUP BY digit  ORDER BY digit; ", [$userid]);
            // $config     = DB::select("SELECT  * from tbl_config ");
            // $user       = DB::select("select * From tbl_user where is_active=1;");
            $config     = $this->getConfig();
            $user       = $this->getUser();
            // dd($bet_data);
            $data['bet'] = $bet_data;
            $data['configData'] = $config;
            $data['userData'] = $user;
            return view('admin/admin',$data);
        }else{
            return   redirect('admin/login');
        }
    }
}
