<!DOCTYPE html>

<html lang="en">
    <head>
        <title>Lottery</title>

        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width,height=device-height,user-scalable=no" />
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>

        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/css/bootstrap.min.css" rel="stylesheet">
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/js/bootstrap.bundle.min.js"></script>
        <script src="https://az.webstarterz.com/blurt-lib/dist/js/blurt.min.js"></script>
        <link href="https://az.webstarterz.com/blurt-lib/dist/css/blurt.min.css" rel="stylesheet">

        <script src="https://az.webstarterz.com/MyLib/toast/toast.js"></script>
        <link href="https://az.webstarterz.com/MyLib/toast/toast.css" rel="stylesheet">
        <link href="css/commom.css" rel="stylesheet">
        <link href="https://fonts.cdnfonts.com/css/calculator" rel="stylesheet">

    </head>

    <?php
        foreach($configData as $key => $value) {
            $config[$value->name]  = $value->value ;
        }
        $agt_name = "Agt 001";
        $cur_t = date('H:i');
        $time1 = "11:30";
        $time2 = "4:30";
        $time = 1;
        $show_time = "00:00";
        if ($cur_t < $time1)
        {
            $show_time = $time1;
            $time = 1;
        }
        elseif($cur_t < $time2)
        {
            $show_time = $time2;
            $time = 1;
        }
        else $time = 3;
    ?>
    <style>
        body{
            height: auto;
            background: #eff !important;
        }
        #root{
            /* max-height: 1000px !important; */
            /* overflow: scroll; */
        }
        #main{
            background-color: gray;
        }
        table{
            margin: 0px !important;
        }
        #snackbar{
            z-index : 999 !important;
        }
        .table-responsive{
            margin: 0px !important;
        }
        #main-table{
            border: 1px solid #aaa;
            /* padding: 15px; */
            overflow-y: auto;
            /* height: 67% !important; */
        }
        .hid{
            visibility: collapse;
        }
        td{
            border-width: 0 2px;
            font-size: 12px  !important;
            padding: .3rem .5rem !important;
        }

        /* table {
        border-collapse: separate;
        border-spacing: 0;
        } */
        .tbl-header *{
            font-size: 15px !important;
            font-weight: bold;
        }
        td {
            border: solid 1px #888;
            border-style: none solid  none;
            padding: 10px;
        }
        #main-table-body > tr :first-child{
          background-color: #efefef !important;
        }
        .header-bar *{
            font-size : 14px !important;
        }
        #num-table{
            font-size: 15px !important;
            font-weight: bold;
            height: 100% !important;
        }
        #div-input{
            height: 30% !important;
        }
        #num-table > tbody >  tr > td{
            font-size: 20 px !important;
            font-weight: bold;
            background: #dfdfdf;
            border: solid #555;
        }
        #num-table > tbody > tr > td {
            width: 20%;
        }
        .no-scroll{
            overflow: hidden;;
        }
        .table-main-data{
            border-bottom : solid #787 2px !important;
        }
        #main-table-body > tr >   td{
            font-weight: 501 !important;
            font-size: 11px !important;
        }

        td:hover {
            filter: contrast(1.75);
            }

        /* td:hover {background-color: #a77 !important;} */
        .mc{
            padding-left: 25px !important;
            margin-right: 5px !important;
        }
        .tr-num{
            /*height: 40px  !important;*/
        }
        .tr-num > td {
          height: 45px;
          vertical-align: middle !important;
          text-align : center  !important;
          font-size: 23px !important;
          font-weight: 501 !important;
        }
        .table-bet > tbody > tr > td {
            width: 50%;
            height: 40px !important;
        }
        #num-bet{
            background-color: #111 !important;
            padding: 0 !important;
        }
        #num-result{
            width: 100% !important;
            font-size: 23px !important;
            padding: 5px;
            color: #11f;

        }
        #btn-x{
            background-color: red !important;
            color: wheat;
        }
        .color-info{
            /* color: #200df0 !important; */
        }
        .bg-black{
            background-color: #111  !important;
            color: #efefef;
        }
        .btn-bet{
            font-size: 21px !important;
        }
        .bg-info2{
            background-color : #9575CD !important;
        }
        .bg-info3{
            background-color : #263238 !important;
            color : #FAFAFA !important;
        }

        .bg-success2{
            background-color:  #2196F3 !important;
        }
        .bg-secondary2{
            background-color:  #4CAF50 !important;
        }
        .text-red{
            color : #f22;
        }
        .btn-cursor{
            cursor: pointer;
        }
        #div-flex{
            display: flex;
            height:  58% !important;
        }
        #table-add-num > tbody > tr > td:first-child{
            padding-left: 2px  !important;
        }
        #table-add-num > tbody > tr > td:nth-child(2) ,   #table-add-num > tbody > tr >  td:nth-child(3){
            padding-left: 0px  !important;
            padding-right: 0px  !important;
            text-align: right !important;
        }
        #table-add-num > tbody > tr{

            line-height:  25px !important;

        }
        #table-add-num > tbody > tr> td{
            font-weight: 400 !important;
            border-bottom: 2px solid #121 !important;
            border-left: 0px  !important;
            border-right: 0px !important;
            font-size: 15px !important;
            padding-left: 0 !important;
            height: 100% !important;
            /* padding-top: 8px !important;
            padding-bottom: 8px !important; */
        }


        .tbl-added-num{
            overflow:  scroll !important;
            scroll-behavior: auto !important;
        }
        .tbl-added-num > tbody > tr > td:nth-child(even){
            /* background-color : #dfdfdf !important; */
            /* border: 1px solid #343434 !important; */

        }
        .tbl-added-num > tbody > tr {
            /* border: 1px groove #343434 !important; */
        }
        .tbl-added-num > tbody > tr > td{
            height: 15px !important;
            width: 25% !important;
            padding-inline: 3.5px !important;
            font-size: 13px !important;
            border: 1px groove #343434 !important;
            /* font-family: 'Brush Script MT', fantasy ; */
            /* font-weight: 600; */
            transform: scale(1, 1.2);
            color : #00f;
            font-family: 'Calculator', sans-serif;

        }



        .tbl-added-num > tbody > tr > td span:last-child{ /*not compatible with <=IE8*/
            color:#333;
            float:right;
            /* font-family: 'Brush Script MT', fantasy ; */
            /* font-weight: 600; */
        }
        #div-add-num > table{
            overflow: scroll;
        }
        #div-add-num{
            width:  35% !important;
            overflow: scroll;
        }
        #div-added-num{
            width: 67% !important;
            overflow: scroll;

        }
        #berfore-bet-total{
            text-align: right !important;
            padding: 5px !important;
        }

                /* -----
        SVG Icons - svgicons.sparkk.fr
        ----- */

        .svg-icon {
            width: 1.8em;
            height: 1.8em;
        }

        .svg-icon path,
        .svg-icon polygon,
        .svg-icon rect {
        fill: #4691f6;
        }

        .svg-icon circle {
        stroke: #4691f6;
        stroke-width: 1;
        }

        .big-text{
            font-size: 24px !important;
            font-weight : 600 ;
            color : #f10;
        }
        .grid-container {
        display: grid;
        grid-template-columns: auto auto auto;
        /* background-color: #2196F3; */
        /* padding: 10px; */
        border-left: 2px dotted #232;
        overflow: scroll !important;
        height: 100% !important;
        }
        .grid-item {
        /* background-color: rgba(255, 255, 255, 0.8); */
        border-right: 0.5px solid gray;
        border-bottom: 0.5px solid gray;
        /* padding: 8px; */
        /* font-size: 30px; */
        text-align: center;
        }
        .unselectable {
            -webkit-touch-callout: none;
            -webkit-user-select: none;
            -khtml-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
        }
        body {
            overflow: auto;
            margin: 0;
            overscroll-behavior: contain;
        }
        .mc > svg{
            width: 20px !important;
            padding-left : 3px;
        }
        #eql_amount{
            margin-top: 2%;
            width : 50% !important;
        }
        #EqlModal{
            height: 80% !important;
        }
        #EqlModal > div ,#EqlModal > div > div ,#EqlModal > div > div> div{
            height: 90% !important;
        }
    </style>
    <script>

        function show_toast(msg="Format Error !!!"){
                toast(msg,"snackbar",3000);
        }
        var limit = <?php echo $config['limit'] ;?> ;

        $(document).ready(function(){

            String.prototype.isNumber = function(){return /^\d+$/.test(this);}
            const couple = ["00","11","22","33","44","55","66","77","88","99"];
            class NumF{
                constructor(i_text, total) {
                    this.i_text = i_text;
                    this.total = total;
                }
            }
            class NumList{
                constructor(){
                    this.NumF  = [];
                }
                add(NumF){
                    this.NumF.push(NumF);
                }
                remove(i){
                    this.NumF.splice(i,1);
                }
                getLength(){
                    return this.NumF.length;
                }

            }
            var DataList = new NumList();

            function storeData(data){
                DataList.add(data);
                // console.log(DataList);
                console.log(JSON.stringify(DataList));
                localStorage.setItem('data', JSON.stringify(DataList));
            }
            function deleteData(i){
                i = i-1;
                console.log("i",i);
                DataList.remove(i);
                localStorage.setItem('data', JSON.stringify(DataList));
            }
            function checkNum(v1){
                if(v1.length < 8){
                    if(v1> 5 && v1.length <= 7){
                        i_text = v1.substring(0,2)+" "+v1.substring(2);
                        total = v1.substring(2)*1;
                        return new NumF(i_text,total);
                    }
                }
                return 0;
            }
            function checkR(v1){
                console.log("check R");
                if(v1.length>= 6 && v1.length <= 14){
                    var v2 = v1.substring(0,2);
                    var v3 = v1.substring(3);
                    var vr = v1.substr(2,1);
                    console.log("v2",v2);
                    console.log("v2",v2);
                    console.log("v3",v3);
                    if(vr == "R")
                    {
                        if(v2.isNumber() && v3.isNumber() && !couple.includes(v2) ){
                        i_text = v2+" R "+v3;
                        total = v3 * 2;
                        return new NumF(i_text,total);
                        }
                    }else if(v2.isNumber() && vr!="R"  ){

                        v3 = v1.substring(2);
                        v4 = v3.substring(0, v3.indexOf("R"));
                        v5 = v3.substring(v3.indexOf("R")+1);

                        if(v4.isNumber() && v5.isNumber()){

                            i_text = v2 + " "+v4 +" R "+v5;
                            total  = (v4*1) + (v5*1);
                            return new NumF(i_text,total);
                        }
                    }else{
                        console.log("v2__",v2);
                        console.log("R wrong");
                        show_toast();
                    }

                }
                return 0;
            }
            function checkP(v1){
                console.log("check P");
                if(v1.length>= 5 && v1.length <= 7){
                    var v2 = v1.substring(0,1);
                    var v3 = v1.substring(2);
                    if(v2.isNumber() && v3.isNumber()){
                        i_text = v2+"P "+v3;
                        total = v3 * 19;
                        return new NumF(i_text,total);
                    }else{
                        console.log("P wrong");
                        show_toast();
                    }
                }
                return 0;
            }
            function checkF(v1){
                console.log("check F");
                if(v1.length>= 5 && v1.length <= 7){
                    var v2;
                    var v3;
                    if(v1.search("F")==0){
                        v2 = v1.substring(1,2);
                        v3 = v1.substring(2);
                        if(v2.isNumber() && v3.isNumber()){
                            i_text ="F "+ v2+" "+v3;
                            total = v3 * 10;
                            return new NumF(i_text,total);
                        }else{
                            console.log("F wrong");
                            show_toast();
                        }
                    }else{
                        v2 = v1.substring(0,1);
                        v3 = v1.substring(2);
                        if(v2.isNumber() && v3.isNumber()){
                            i_text = v2+" F "+v3;
                            total = v3 * 10;
                            return new NumF(i_text,total);
                        }else{
                            console.log("F wrong");
                            show_toast();
                        }
                    }
                }
                return 0;
            }
            function checkB(v1){
                console.log("check B");
                if(v1.length>= 5 && v1.length <= 7){
                    var v2 = v1.substring(0,1);
                    var v3 = v1.substring(2);
                    if(v2.isNumber() && v3.isNumber()){
                        i_text = v2+" B "+v3;
                        total = v3 * 10;
                        return new NumF(i_text,total);
                    }else{
                        console.log("B wrong");
                        show_toast();
                    }
                }
                return 0;
            }
            function checkA(v1){
                console.log("check A");
                if(v1.length>= 4 && v1.length <= 6){
                    var v2 = "";
                    var v3 = v1.substring(1);
                    if( v3.isNumber()){
                        i_text = v2+" A "+v3;
                        total = v3 * 10;
                        return new NumF(i_text,total);
                    }else{
                        console.log("A wrong");
                        show_toast();
                    }
                }
                return 0;
            }
            function checkW(v1){
                console.log("check W");
                if(v1.length>= 4 && v1.length <= 6){
                    var v2 = "";
                    var v3 = v1.substring(1);
                    if( v3.isNumber()){
                        i_text = v2+" W "+v3;
                        total = v3 * 10;
                        return new NumF(i_text,total);
                    }else{
                        console.log("W wrong");
                        show_toast();
                    }
                }
                return 0;
            }
            function checkN(v1){
                console.log("check N");
                if(v1.length>= 4 && v1.length <= 6){
                    var v2 = "";
                    var v3 = v1.substring(1);
                    if( v3.isNumber()){
                        i_text = v2+" N "+v3;
                        total = v3 * 10;
                        return new NumF(i_text,total);
                    }else{
                        console.log("N wrong");
                        show_toast();
                    }
                }
                return 0;
            }
            // function checkEql(v1){
            //     console.log("check =");
            //     if(v1.length>= 6 && v1.length <= 16){
            //         var v2 = v1.substring(0,v1.search("="));
            //         var v3 = v1.substring(v1.search("=")+1);
            //         if(v2.isNumber() && v3.isNumber() && (v2.length%2)==0){
            //             i_text = v2+" = "+v3;
            //             total = v3 * (v2.length/2);
            //             return new NumF(i_text,total);
            //         }else{
            //             console.log("= wrong");
            //             show_toast();
            //         }
            //     }
            //     return 0;
            // }

            function changeTotal(newV){
                var current =$("#b-total").html()*1;
                console.log("current total",newV);
                $("#b-total").html((newV*1)+(current*1));



            }
            function isDoubleClicked(element) {
                //if already clicked return TRUE to indicate this click is not allowed
                if (element.hasClass("is-clicked")) return true;

                //mark as clicked for 1 second
                element.addClass("is-clicked");
                setTimeout(function () {
                    element.removeClass('is-clicked');
                }, 1000);

                //return FALSE to indicate this click was allowed
                return false;
            }
            function deleteButton(){

                $(".del-svg").click(function(e){
                    if (isDoubleClicked($(this)))
                        return;
                    e.preventDefault();
                        console.log(this);
                        var i = $(this).attr("data-id");
                        var total = $(this).attr("data-total");
                        console.log("i",i);
                        console.log("total",total);
                        deleteData(i);
                        changeTotal(total*-1);
                        // $(this).parent().hide();
                        $(this).parent().hide();
                        console.log(JSON.stringify(DataList));

                });
            }
            const numClick = function(cur){
                var current = $("#num-result").val() ;
                var inp = $(cur).text() ;
                current = current+""+inp;
                $("#num-result").val(current );
            }
            $(".btn-num").click(function(){
                numClick(this);
            });
            $(".btn-bet").click(function(){
                console.log("btn-bet click");
                var betData = localStorage.getItem("data");
                console.log("betdata",betData);
                $.post("/bet",betData , function(data, status){
                    toast("Add bet number","snackbar",3000);
                    // location.href = location.href;
                    // console.log("Data: " + data + "\nStatus: " + status);

                });
            });

            $("#btn-x").click(function(){
                // remove last charcter or num
                var current = $("#num-result").val() ;
                console.log(current);
                var current = current.substr(0,current.length-1)
                $("#num-result").val(current );
                // $("#num-result").focus();
            });
            var timer;
            $('#btn-x').on("mousedown",function(){
                timer = setTimeout(function(){
                    console.log("long press");
                    $("#num-result").val("");
                    var div = $('#btn-x');
                    div.animate({opacity: '0.4'}, "slow");
                    div.animate({opacity: '0.6'}, "slow");
                    div.animate({opacity: '1'}, "slow");
                },1600);
            }).on("mouseup mouseleave",function(){
                clearTimeout(timer);
            });
            $("#btn-ok").click(function(){

                var current = $("#num-result").val() ;
                var res ;
                if(current.length>=5 && current.length <8 && current.isNumber()){
                    res = checkNum(current);
                    // console.log(res);
                    if(res.total >= 100 && res.total <= limit ){
                        storeData(res);
                        var i = DataList.getLength();
                        var svg= '<svg class="svg-icon" viewBox="0 0 20 20"><path d="M17.114,3.923h-4.589V2.427c0-0.252-0.207-0.459-0.46-0.459H7.935c-0.252,0-0.459,0.207-0.459,0.459v1.496h-4.59c-0.252,0-0.459,0.205-0.459,0.459c0,0.252,0.207,0.459,0.459,0.459h1.51v12.732c0,0.252,0.207,0.459,0.459,0.459h10.29c0.254,0,0.459-0.207,0.459-0.459V4.841h1.511c0.252,0,0.459-0.207,0.459-0.459C17.573,4.127,17.366,3.923,17.114,3.923M8.394,2.886h3.214v0.918H8.394V2.886z M14.686,17.114H5.314V4.841h9.372V17.114z M12.525,7.306v7.344c0,0.252-0.207,0.459-0.46,0.459s-0.458-0.207-0.458-0.459V7.306c0-0.254,0.205-0.459,0.458-0.459S12.525,7.051,12.525,7.306M8.394,7.306v7.344c0,0.252-0.207,0.459-0.459,0.459s-0.459-0.207-0.459-0.459V7.306c0-0.254,0.207-0.459,0.459-0.459S8.394,7.051,8.394,7.306"></path></svg>';
                        $('#table-add-num  tr:last').after("<tr><td>"+res.i_text+"</td><td>"+res.total+"</td><td class='del-svg' data-total='"+res.total+"' data-id='"+i+"'>"+svg+"</td></tr>");
                        $("#num-result").val("") ;
                        changeTotal(res.total);deleteButton();
                    }else{
                        show_toast();
                    }
                }else if( current.includes("R") ){
                    console.log("RR ");
                    res = checkR(current);
                    // console.log(res);
                    if(res.total >= 100 && (res.total/2) <= limit ){
                        storeData(res);
                        var i = DataList.getLength();
                        var svg= '<svg class="svg-icon" viewBox="0 0 20 20"><path d="M17.114,3.923h-4.589V2.427c0-0.252-0.207-0.459-0.46-0.459H7.935c-0.252,0-0.459,0.207-0.459,0.459v1.496h-4.59c-0.252,0-0.459,0.205-0.459,0.459c0,0.252,0.207,0.459,0.459,0.459h1.51v12.732c0,0.252,0.207,0.459,0.459,0.459h10.29c0.254,0,0.459-0.207,0.459-0.459V4.841h1.511c0.252,0,0.459-0.207,0.459-0.459C17.573,4.127,17.366,3.923,17.114,3.923M8.394,2.886h3.214v0.918H8.394V2.886z M14.686,17.114H5.314V4.841h9.372V17.114z M12.525,7.306v7.344c0,0.252-0.207,0.459-0.46,0.459s-0.458-0.207-0.458-0.459V7.306c0-0.254,0.205-0.459,0.458-0.459S12.525,7.051,12.525,7.306M8.394,7.306v7.344c0,0.252-0.207,0.459-0.459,0.459s-0.459-0.207-0.459-0.459V7.306c0-0.254,0.207-0.459,0.459-0.459S8.394,7.051,8.394,7.306"></path></svg>';
                        $('#table-add-num  tr:last').after("<tr><td>"+res.i_text+"</td><td>"+res.total+"</td><td class='del-svg'  data-total='"+res.total+"' data-id='"+i+"'>"+svg+"</td></tr>");
                        $("#num-result").val("") ;
                        changeTotal(res.total);deleteButton();
                    }else{
                        show_toast();
                    }

                }else if( current.includes("P") ){
                    console.log("PP include ");
                    res = checkP(current);
                    // console.log(res);
                    if(res.total >= 100 && (res.total/19) <= limit ){
                        storeData(res);
                        var i = DataList.getLength();
                        var svg= '<svg class="svg-icon" viewBox="0 0 20 20"><path d="M17.114,3.923h-4.589V2.427c0-0.252-0.207-0.459-0.46-0.459H7.935c-0.252,0-0.459,0.207-0.459,0.459v1.496h-4.59c-0.252,0-0.459,0.205-0.459,0.459c0,0.252,0.207,0.459,0.459,0.459h1.51v12.732c0,0.252,0.207,0.459,0.459,0.459h10.29c0.254,0,0.459-0.207,0.459-0.459V4.841h1.511c0.252,0,0.459-0.207,0.459-0.459C17.573,4.127,17.366,3.923,17.114,3.923M8.394,2.886h3.214v0.918H8.394V2.886z M14.686,17.114H5.314V4.841h9.372V17.114z M12.525,7.306v7.344c0,0.252-0.207,0.459-0.46,0.459s-0.458-0.207-0.458-0.459V7.306c0-0.254,0.205-0.459,0.458-0.459S12.525,7.051,12.525,7.306M8.394,7.306v7.344c0,0.252-0.207,0.459-0.459,0.459s-0.459-0.207-0.459-0.459V7.306c0-0.254,0.207-0.459,0.459-0.459S8.394,7.051,8.394,7.306"></path></svg>';
                        $('#table-add-num  tr:last').after("<tr><td>"+res.i_text+"</td><td>"+res.total+"</td><td class='del-svg' data-total='"+res.total+"'  data-id='"+i+"'>"+svg+"</td></tr>");
                        $("#num-result").val("") ;
                        changeTotal(res.total);deleteButton();deleteButton();
                    }else{
                        show_toast();
                    }

                }else if( current.includes("A") ){
                    console.log("A include ");
                    res = checkA(current);
                    // console.log(res);
                    if(res.total >= 100  && (res.total/10) <= limit ){
                        storeData(res);
                        var i = DataList.getLength();
                        var svg= '<svg class="svg-icon" viewBox="0 0 20 20"><path d="M17.114,3.923h-4.589V2.427c0-0.252-0.207-0.459-0.46-0.459H7.935c-0.252,0-0.459,0.207-0.459,0.459v1.496h-4.59c-0.252,0-0.459,0.205-0.459,0.459c0,0.252,0.207,0.459,0.459,0.459h1.51v12.732c0,0.252,0.207,0.459,0.459,0.459h10.29c0.254,0,0.459-0.207,0.459-0.459V4.841h1.511c0.252,0,0.459-0.207,0.459-0.459C17.573,4.127,17.366,3.923,17.114,3.923M8.394,2.886h3.214v0.918H8.394V2.886z M14.686,17.114H5.314V4.841h9.372V17.114z M12.525,7.306v7.344c0,0.252-0.207,0.459-0.46,0.459s-0.458-0.207-0.458-0.459V7.306c0-0.254,0.205-0.459,0.458-0.459S12.525,7.051,12.525,7.306M8.394,7.306v7.344c0,0.252-0.207,0.459-0.459,0.459s-0.459-0.207-0.459-0.459V7.306c0-0.254,0.207-0.459,0.459-0.459S8.394,7.051,8.394,7.306"></path></svg>';
                        $('#table-add-num  tr:last').after("<tr><td>"+res.i_text+"</td><td>"+res.total+"</td><td class='del-svg' data-total='"+res.total+"'  data-id='"+i+"'>"+svg+"</td></tr>");
                        $("#num-result").val("") ;
                        changeTotal(res.total);deleteButton();
                    }else{
                        show_toast();
                    }

                }else if( current.includes("W") ){
                    console.log("W include ");
                    res = checkW(current);
                    // console.log(res);
                    if(res.total >= 100   && (res.total/10) <= limit ){
                        storeData(res);
                        var i = DataList.getLength();
                        var svg= '<svg class="svg-icon" viewBox="0 0 20 20"><path d="M17.114,3.923h-4.589V2.427c0-0.252-0.207-0.459-0.46-0.459H7.935c-0.252,0-0.459,0.207-0.459,0.459v1.496h-4.59c-0.252,0-0.459,0.205-0.459,0.459c0,0.252,0.207,0.459,0.459,0.459h1.51v12.732c0,0.252,0.207,0.459,0.459,0.459h10.29c0.254,0,0.459-0.207,0.459-0.459V4.841h1.511c0.252,0,0.459-0.207,0.459-0.459C17.573,4.127,17.366,3.923,17.114,3.923M8.394,2.886h3.214v0.918H8.394V2.886z M14.686,17.114H5.314V4.841h9.372V17.114z M12.525,7.306v7.344c0,0.252-0.207,0.459-0.46,0.459s-0.458-0.207-0.458-0.459V7.306c0-0.254,0.205-0.459,0.458-0.459S12.525,7.051,12.525,7.306M8.394,7.306v7.344c0,0.252-0.207,0.459-0.459,0.459s-0.459-0.207-0.459-0.459V7.306c0-0.254,0.207-0.459,0.459-0.459S8.394,7.051,8.394,7.306"></path></svg>';
                        $('#table-add-num  tr:last').after("<tr><td>"+res.i_text+"</td><td>"+res.total+"</td><td class='del-svg' data-total='"+res.total+"'  data-id='"+i+"'>"+svg+"</td></tr>");
                        $("#num-result").val("") ;
                        changeTotal(res.total);deleteButton();
                    }else{
                        show_toast();
                    }

                }else if( current.includes("N") ){
                    console.log("N include ");
                    res = checkN(current);
                    // console.log(res);
                    if(res.total >= 100   && (res.total/10) <= limit ){
                        storeData(res);
                        var i = DataList.getLength();
                        var svg= '<svg class="svg-icon" viewBox="0 0 20 20"><path d="M17.114,3.923h-4.589V2.427c0-0.252-0.207-0.459-0.46-0.459H7.935c-0.252,0-0.459,0.207-0.459,0.459v1.496h-4.59c-0.252,0-0.459,0.205-0.459,0.459c0,0.252,0.207,0.459,0.459,0.459h1.51v12.732c0,0.252,0.207,0.459,0.459,0.459h10.29c0.254,0,0.459-0.207,0.459-0.459V4.841h1.511c0.252,0,0.459-0.207,0.459-0.459C17.573,4.127,17.366,3.923,17.114,3.923M8.394,2.886h3.214v0.918H8.394V2.886z M14.686,17.114H5.314V4.841h9.372V17.114z M12.525,7.306v7.344c0,0.252-0.207,0.459-0.46,0.459s-0.458-0.207-0.458-0.459V7.306c0-0.254,0.205-0.459,0.458-0.459S12.525,7.051,12.525,7.306M8.394,7.306v7.344c0,0.252-0.207,0.459-0.459,0.459s-0.459-0.207-0.459-0.459V7.306c0-0.254,0.207-0.459,0.459-0.459S8.394,7.051,8.394,7.306"></path></svg>';
                        $('#table-add-num  tr:last').after("<tr><td>"+res.i_text+"</td><td>"+res.total+"</td><td class='del-svg'  data-total='"+res.total+"'  data-id='"+i+"'>"+svg+"</td></tr>");
                        $("#num-result").val("") ;
                        changeTotal(res.total);deleteButton();
                    }else{
                        show_toast();
                    }

                }else if( current.includes("F") ){
                    console.log("F include ");
                    res = checkF(current);
                    // console.log(res);
                    if(res.total >= 100    && (res.total/10) <= limit ){
                        storeData(res);
                        var i = DataList.getLength();
                        var svg= '<svg class="svg-icon" viewBox="0 0 20 20"><path d="M17.114,3.923h-4.589V2.427c0-0.252-0.207-0.459-0.46-0.459H7.935c-0.252,0-0.459,0.207-0.459,0.459v1.496h-4.59c-0.252,0-0.459,0.205-0.459,0.459c0,0.252,0.207,0.459,0.459,0.459h1.51v12.732c0,0.252,0.207,0.459,0.459,0.459h10.29c0.254,0,0.459-0.207,0.459-0.459V4.841h1.511c0.252,0,0.459-0.207,0.459-0.459C17.573,4.127,17.366,3.923,17.114,3.923M8.394,2.886h3.214v0.918H8.394V2.886z M14.686,17.114H5.314V4.841h9.372V17.114z M12.525,7.306v7.344c0,0.252-0.207,0.459-0.46,0.459s-0.458-0.207-0.458-0.459V7.306c0-0.254,0.205-0.459,0.458-0.459S12.525,7.051,12.525,7.306M8.394,7.306v7.344c0,0.252-0.207,0.459-0.459,0.459s-0.459-0.207-0.459-0.459V7.306c0-0.254,0.207-0.459,0.459-0.459S8.394,7.051,8.394,7.306"></path></svg>';
                        $('#table-add-num  tr:last').after("<tr><td>"+res.i_text+"</td><td>"+res.total+"</td><td class='del-svg'  data-total='"+res.total+"'  data-id='"+i+"'>"+svg+"</td></tr>");
                        $("#num-result").val("") ;
                        changeTotal(res.total);deleteButton();
                    }else{
                        show_toast();
                    }

                }else if( current.includes("B") ){
                    console.log("B include ");
                    res = checkB(current);
                    // console.log(res);
                    if(res.total >= 100   && (res.total/10) <= limit ){
                        storeData(res);
                        console.log("result = ",res);
                        var i = DataList.getLength();
                        var svg= '<svg class="svg-icon" viewBox="0 0 20 20"><path d="M17.114,3.923h-4.589V2.427c0-0.252-0.207-0.459-0.46-0.459H7.935c-0.252,0-0.459,0.207-0.459,0.459v1.496h-4.59c-0.252,0-0.459,0.205-0.459,0.459c0,0.252,0.207,0.459,0.459,0.459h1.51v12.732c0,0.252,0.207,0.459,0.459,0.459h10.29c0.254,0,0.459-0.207,0.459-0.459V4.841h1.511c0.252,0,0.459-0.207,0.459-0.459C17.573,4.127,17.366,3.923,17.114,3.923M8.394,2.886h3.214v0.918H8.394V2.886z M14.686,17.114H5.314V4.841h9.372V17.114z M12.525,7.306v7.344c0,0.252-0.207,0.459-0.46,0.459s-0.458-0.207-0.458-0.459V7.306c0-0.254,0.205-0.459,0.458-0.459S12.525,7.051,12.525,7.306M8.394,7.306v7.344c0,0.252-0.207,0.459-0.459,0.459s-0.459-0.207-0.459-0.459V7.306c0-0.254,0.207-0.459,0.459-0.459S8.394,7.051,8.394,7.306"></path></svg>';
                        $('#table-add-num  tr:last').after("<tr><td>"+res.i_text+"</td><td>"+res.total+"</td><td class='del-svg'  data-total='"+res.total+"'  data-id='"+i+"'>"+svg+"</td></tr>");
                        $("#num-result").val("") ;
                        changeTotal(res.total);deleteButton();
                    }else{
                        show_toast();
                    }

                // }else if( current.includes("=") ){
                //     console.log("= include ");
                //     res = checkEql(current);
                //     // console.log(res);
                //     if(res.total >= 100    && (res.total/(res.i_text.length/2)) <= limit ){
                //         storeData(res);
                //         var svg= '<svg class="svg-icon" viewBox="0 0 20 20"><path d="M17.114,3.923h-4.589V2.427c0-0.252-0.207-0.459-0.46-0.459H7.935c-0.252,0-0.459,0.207-0.459,0.459v1.496h-4.59c-0.252,0-0.459,0.205-0.459,0.459c0,0.252,0.207,0.459,0.459,0.459h1.51v12.732c0,0.252,0.207,0.459,0.459,0.459h10.29c0.254,0,0.459-0.207,0.459-0.459V4.841h1.511c0.252,0,0.459-0.207,0.459-0.459C17.573,4.127,17.366,3.923,17.114,3.923M8.394,2.886h3.214v0.918H8.394V2.886z M14.686,17.114H5.314V4.841h9.372V17.114z M12.525,7.306v7.344c0,0.252-0.207,0.459-0.46,0.459s-0.458-0.207-0.458-0.459V7.306c0-0.254,0.205-0.459,0.458-0.459S12.525,7.051,12.525,7.306M8.394,7.306v7.344c0,0.252-0.207,0.459-0.459,0.459s-0.459-0.207-0.459-0.459V7.306c0-0.254,0.207-0.459,0.459-0.459S8.394,7.051,8.394,7.306"></path></svg>';
                //         $('#table-add-num  tr:last').after("<tr><td>"+res.i_text+"</td><td>"+res.total+"</td><td class='del-svg' data-id='"+i+"'>"+svg+"</td></tr>");
                //         $("#num-result").val("") ;
                //         changeTotal(res.total);deleteButton();
                //     }else{
                //         show_toast();
                //     }
                }else{
                    show_toast();
                    return false;
                }
                // if(res.total>0){
                    // changeTotal(res.total);
                // }
            });

            function checkEql(num,amount){
                if(num.isNumber() && num.length == 2 && amount.length > 2 & amount.length <=6 && amount.isNumber()){
                    return new NumF(num+" "+amount,amount);
                }
            }
            $("#btn-eql-ok").click(function(){
                var current = $("#eqlNum").val();
                var amount = $("#eql_amount").val();
                if(current.length > 2  && amount.length >2 && amount.length<=6  && amount < limit){
                    const result = current.match(/.{1,2}/g) ?? [];

                    result.forEach(element => {
                        console.log(element);
                        var res = checkEql(element,amount);
                        storeData(res);
                        var i = DataList.getLength();
                        console.log("result  = ",res);
                        var svg= '<svg class="svg-icon" viewBox="0 0 20 20"><path d="M17.114,3.923h-4.589V2.427c0-0.252-0.207-0.459-0.46-0.459H7.935c-0.252,0-0.459,0.207-0.459,0.459v1.496h-4.59c-0.252,0-0.459,0.205-0.459,0.459c0,0.252,0.207,0.459,0.459,0.459h1.51v12.732c0,0.252,0.207,0.459,0.459,0.459h10.29c0.254,0,0.459-0.207,0.459-0.459V4.841h1.511c0.252,0,0.459-0.207,0.459-0.459C17.573,4.127,17.366,3.923,17.114,3.923M8.394,2.886h3.214v0.918H8.394V2.886z M14.686,17.114H5.314V4.841h9.372V17.114z M12.525,7.306v7.344c0,0.252-0.207,0.459-0.46,0.459s-0.458-0.207-0.458-0.459V7.306c0-0.254,0.205-0.459,0.458-0.459S12.525,7.051,12.525,7.306M8.394,7.306v7.344c0,0.252-0.207,0.459-0.459,0.459s-0.459-0.207-0.459-0.459V7.306c0-0.254,0.207-0.459,0.459-0.459S8.394,7.051,8.394,7.306"></path></svg>';
                        $('#table-add-num  tr:last').after("<tr><td>"+res.i_text+"</td><td>"+res.total+"</td><td class='del-svg' data-id='"+i+"'>"+svg+"</td></tr>");
                        $("#num-result").val("") ;
                        changeTotal(res.total);deleteButton();
                        $("#btn-eql-close").click();
                        $("#eqlNum").val("");
                        $("#eql_amount").val("");
                        $("#eqlTxt").text("");
                        // return new NumF(i_text,total);

                    });

                }else{
                    $("#eql-err").text("Format Erorr");
                }
            });

            $(".btn-eql").click(function(){
                $('#EqlModal').modal('toggle');
            });

            $("#eqlNum").keyup(function(){
                var num = $(this).val();
                const result = num.match(/.{1,2}/g) ?? [];
                txt  = result.join('_');
                $("#eqlTxt").text(txt);
            });

            $("#btn-user").click(function(){
                    console.log("as");
                        $('#agentModal').modal('toggle');
                });

    });
    document.addEventListener("keydown", function(event) {
        if (event.code === "KeyR")
        {
            location.href=location.href;
            event.preventDefault();
        }
    });
    function isNumberKey(evt){
        var charCode = (evt.which) ? evt.which : evt.keyCode
        if (charCode > 31 && (charCode < 48 || charCode > 57 ))
            return false;
        return true;
    }
    </script>
    <body>
        <div id="root">
            <div id="header">

            </div>

            <div id="main-body">
                <div class="container_" id="main_">
                    <div class="table-responsive">
                        <table class="table">
                            <tr class="header-bar">
                                <td class="bg-info3" colspan="3">
                                    <div>
                                        <marquee width="100%" direction="right" >
                                            This is a sample warming text, Welcome.
                                        </marquee>
                                    </div>
                                </td>
                                <td class="bg-info3 mc" >
                                    
                                    <span onclick="location.href=location.href">25/01/2023</span>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000" style="fill:#0273a2"><title>Logout SVG icon</title><g><g><path d="M628.3,858.3H124.9V141.7h503.5c11.2,0,20.2-9.1,20.2-20.2V47c0-11.2-9.1-20.2-20.2-20.2H30.2C19.1,26.8,10,35.8,10,47v906c0,11.2,9.1,20.2,20.2,20.2h598.1c11.2,0,20.2-9.1,20.2-20.2v-74.4C648.6,867.4,639.5,858.3,628.3,858.3z"></path><path d="M984.1,485.7L711.9,213.6c-7.6-7.6-21-7.6-28.6,0l-64.6,64.6c-7.9,7.9-7.9,20.7,0,28.6l122.9,122.9H209.5c-11.2,0-20.2,9.1-20.2,20.2v100.2c0,11.2,9.1,20.2,20.2,20.2h532.2L618.8,693.3c-7.9,7.9-7.9,20.7,0,28.6l64.6,64.6c3.8,3.8,9,5.9,14.3,5.9c5.4,0,10.5-2.1,14.3-5.9l272.2-272.1c3.8-3.8,5.9-8.9,5.9-14.3C990,494.6,987.8,489.5,984.1,485.7z"></path></g></g>
                                    </svg>
                                </td>
                            </tr>
                        </table>
                        <table class="table">
                            <thead>

                            <tr class="tbl-header">
                                <th class="bg-info2"><?php echo e($show_time); ?></th>
                                <th class="bg-success2">Setting</th>
                                <th class="bg-secondary2" id="btn-user"><?php echo e($agt_name); ?></th>
                                <th class="bg-warning"><?php echo e($config['limit']); ?></th>
                            </tr>
                            </thead>
                        </table>
                    </div>

                    <div id="div-flex">
                        <div  id="div-add-num" >
                            <table class="table table-bordered no-scroll" id="table-add-num" >
                                <tbody>
                                    <tr></tr>

                                </tbody>
                            </table>
                            <div id="berfore-bet-total">
                                <p>Total  &nbsp; - &nbsp;<span id="b-total"> 0</span></p>
                            </div>
                        </div>
                        <div id="div-added-num" >
                            <table class="table table-bordered tbl-added-num">
                                <tbody>
                                    
                                    <?php
                                        $data  = json_decode(json_encode($bet), true);
                                        $total_amt = 0;
                                        function getV($arr,$l,$n)
                                        {
                                            if(count($arr)>$l){
                                                return $arr[$l][$n];
                                            }else {
                                                return "";
                                            }
                                        }
                                        function getVamt($arr,$l,$n)
                                        {
                                            if(count($arr)>$l){
                                                return $arr[$l][$n];
                                            }else {
                                                return 0;
                                            }
                                        }
                                    ?>
                                    <?php for($x = 0; $x <= 99/4; $x++): ?>
                                        <?php if( $x != 0): ?>
                                            </tr><tr>
                                        <?php elseif($x == 0): ?>
                                            <tr>
                                        <?php endif; ?>
                                        <?php if(count($data)> $x): ?>
                                            <td><span><?php echo e(getV($data,$x,"digit")); ?></span><span><?php echo e(getV($data,$x,"t_amt")); ?></span></td>
                                            <?php $total_amt += (getVamt($data,$x,"t_amt")*1) ; ?>

                                            <td><span><?php echo e(getV($data,$x+25,"digit")); ?></span><span><?php echo e(getV($data,$x+25,"t_amt")); ?></span></td>
                                            <?php $total_amt += (getVamt($data,$x,"t_amt")*1) ; ?>

                                            <td><span><?php echo e(getV($data,$x+50,"digit")); ?></span><span><?php echo e(getV($data,$x+50,"t_amt")); ?></span></td>
                                            <?php $total_amt += (getVamt($data,$x,"t_amt")*1) ; ?>

                                            <td><span><?php echo e(getV($data,$x+75,"digit")); ?></span><span><?php echo e(getV($data,$x+75,"t_amt")); ?></span></td>
                                            <?php $total_amt += (getVamt($data,$x,"t_amt")*1) ; ?>

                                        <?php else: ?>
                                            <td></td>
                                        <?php endif; ?>

                                    <?php endfor; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div>
                        <table class="table table-bordered table-bet" style='table-layout:fixed;'  >
                            <tbody>
                                <tr>
                                    <td class="text-center bg-black btn-bet" width="75%">BET</td>
                                    <td class="text-center big-text" ><?php echo e(number_format($total_amt)); ?></td>
                                </tr>
                                </tbody>
                        </table>
                    </div>
                    <div id="div-input" class="table-responsive no-scroll" >
                        <table class="table table-bordered"  id="num-table" >
                            <tbody class="table-key ">
                                <tr  class="tr-num">
                                    <td colspan="3" class="text-end"  id="num-bet">
                                        <input type="text" value="" class="caret-bar" id="num-result" inputmode="none"  autocomplete="false" onkeydown="return false">
                                    </td>
                                    <td   id="btn-ok" class="text-center bg-warning btn-cursor unselectable ">OK</td>
                                    <td   class="text-center bg-info text-red  btn-cursor unselectable" id="btn-x">X</td>
                                </tr>

                                <!-- keyboard -->
                                <tr class="tr-num">
                                    <td  class="text-center btn-num  btn-cursor unselectable ">1</td>
                                    <td  class="text-center btn-num btn-cursor  unselectable ">2</td>
                                    <td  class="text-center btn-num btn-cursor  unselectable ">3</td>
                                    <td  class="text-center  btn-num  btn-cursor  unselectable color-info  bg-info">P</td>
                                    <td  class="text-center  btn-num  btn-cursor  unselectable  color-info bg-info">R</td>
                                </tr>
                                <tr class="tr-num">
                                    <td  class="text-center btn-num btn-cursor   unselectable ">4</td>
                                    <td  class="text-center btn-num btn-cursor   unselectable ">5</td>
                                    <td  class="text-center btn-num btn-cursor   unselectable ">6</td>
                                    <td  class="text-center  btn-num  btn-cursor  unselectable   color-info bg-info">F</td>
                                    <td  class="text-center  btn-num  btn-cursor   unselectable  color-info bg-info">B</td>
                                </tr>
                                <tr class="tr-num">
                                    <td  class="text-center btn-num btn-cursor  unselectable ">7</td>
                                    <td  class="text-center btn-num btn-cursor  unselectable ">8</td>
                                    <td  class="text-center btn-num btn-cursor  unselectable ">9</td>
                                    <td  class="text-center  btn-num  btn-cursor  unselectable  color-info btn-num  bg-info">A</td>
                                    <td  class="text-center  btn-num  btn-cursor  unselectable  color-info bg-info">W</td>
                                </tr>
                                <tr class="tr-num">
                                    <td  class="text-center btn-num btn-cursor  unselectable ">0</td>
                                    <td  class="text-center btn-num btn-cursor  unselectable ">00</td>
                                    <td  class="text-center btn-num btn-cursor  unselectable ">000</td>
                                    <td  class="text-center  btn-num  btn-cursor  unselectable  color-info bg-info">N</td>
                                    <td  class="text-center  btn-eql  btn-cursor  unselectable  color-info bg-info">=</td>
                                </tr>
                                <!-- end keyboard -->
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>


        <div class="modal fade" id="EqlModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <br><br>
                    <br><br>
                    <label for="comment"></label>
                    <p id="eqlTxt"></p>
                    <input class="form-control" type="number"  id="eqlNum" rows="5"  placeholder="number"  onkeypress="return isNumberKey(event)">
                    <input class="form-control" type="number"   id ="eql_amount" maxlength="6" minlength="2" placeholder="amount">
                    <br>
                    <button type="button" id="btn-eql-ok" class="btn btn-primary">Ok</button>
                    <button type="button" id="btn-eql-close" class="btn btn-warning" data-bs-dismiss="modal">Cancel</button>
                    <br><br>
                    <span class="text-red" id="eql-err"></span>
                </div>
            </div>
            </div>
        </div>


            <div class="modal fade" id="agentModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Choose Agent</h5>
                    </div>
                    <div class="modal-body">
                        <div>
                            <table class="table table-bordered">
                                <tr>
                                <th> Name </th>
                                </tr>
                                <tr>
                                <td class="pointer "> User 001 </td>
                                </tr>
                                <tr>
                                <td class="pointer "> User 002 </td>
                                </tr>
                                <tr>
                                <td class="pointer "> User 003 </td>
                                </tr>
                                <tr>
                                <td class="pointer "> User 004 </td>
                                </tr>
                            </table>
                            <div>
                                <br>
                                <lable>Name</lable>
                                <input type="text" id="usrname" class="form-control" name="usrname" placeholder="user name">    
                            </div>
                        </div>
                    </div>
                </div>
            </div>


    </body>
</html>
 
<?php /**PATH D:\workspace\lottery\WS\proj\resources\views/agent/agent.blade.php ENDPATH**/ ?>